/* XIM Integrated Products MAX7360 LED Driver
 *
 * Copyright 2009-2012 MAXIM Integrated Products Inc.
 *
 * Licensed under the GPL-2 or later.
 *
 * MAX7360.h
 *
 */

#ifndef _MAX7360_H_
#define _MAX7360_H_

struct max7360_ports {
	int	id;
	u8	port_nr;
	u8	port_pwm;
	u8	max_pwm;
};

struct max7360 {
	//struct gpio_chip chip;
	struct i2c_client *client;
	struct mutex    lock;
	struct device *dev;
	int (*write)(struct device *dev, unsigned int reg, unsigned int val);
	int (*read)(struct device *dev, unsigned int reg);
};


static const uint32_t max7360_matrix_keysDEBUG[] = {
        // (row, column, keyEvent)
        KEY(0, 0, KEY_POWER),
        KEY(0, 1, KEY_RIGHT),
        KEY(0, 2, KEY_DOWN),
        KEY(0, 3, KEY_6), // light
        KEY(0, 4, KEY_VOLUMEUP),

        KEY(1, 0, KEY_8), // GUIDE
        KEY(1, 1, KEY_ENTER),
        KEY(1, 2, KEY_MENU),   //info/menu (82)
        KEY(1, 3, KEY_MUTE),
        KEY(1, 4, KEY_MEDIA),

        KEY(2, 0, KEY_UP),
        KEY(2, 1, KEY_LEFT),
        KEY(2, 2, KEY_BACK),     // exit/back (4)
        KEY(2, 3, KEY_VOLUMEDOWN),
        KEY(2, 4, KEY_HOME),
};

/* Crestron GPIO Matrix Keys for tst600 */
static const uint32_t max7360_matrix_keys[] = {
        // (row, column, keyEvent)
        KEY(0, 0, 0x89),
        KEY(0, 1, 0x8A),
        KEY(0, 2, 0x8F),
        KEY(0, 3, 0x86),
        KEY(0, 4, 0x83),

        KEY(1, 0, 0x88),
        KEY(1, 1, 0x8C),
        KEY(1, 2, 0x8E),
        KEY(1, 3, 0x85),
        KEY(1, 4, 0x82),

        KEY(2, 0, 0x87),
        KEY(2, 1, 0x8B),
        KEY(2, 2, 0x8D),
        KEY(2, 3, 0x84),
        KEY(2, 4, 0x81),
};

const struct matrix_keymap_data max7360_keymap_data = {
        .keymap = max7360_matrix_keys,
        .keymap_size = ARRAY_SIZE(max7360_matrix_keys),
};

#if 0
*/RJK: for imx53 muxio */
static const unsigned int max7360_keypad_row_gpios[] = {
        144,145,146
};

/*COL KEY:GPN3,GPN6,GPN7*/
static const unsigned int max7360_keypad_col_gpios[] = {
        147,150,151
};
#endif

static struct matrix_keypad_platform_data max7360_keypad_platform_data = {
        .keymap_data = &max7360_keymap_data,
     //   .row_gpios = max7360_keypad_row_gpios,
     //   .num_row_gpios = ARRAY_SIZE(max7360_keypad_row_gpios),
     //   .col_gpios = max7360_keypad_col_gpios,
     //   .num_col_gpios = ARRAY_SIZE(max7360_keypad_col_gpios),
        .active_low = 1,

        .debounce_ms = 20,
        .col_scan_delay_us = 5,
};

extern int __max7360_remove(struct device *dev);
extern int __max7360_probe(struct max7360 *ts);


#endif
